// 天猫超市
// 天猫SKU页面，和淘宝不同的是会刷新页面重新载入，直接采集即可，每次一页
// 1.获取分类，如果有多个，判断同时选中的有多个
// https://chaoshi.detail.tmall.com/item.htm?id=747534695596
(function () {
    console.log('tmall.sku-1')
    const defaultTimeout = 3000
    // 连接后台
    const port = chrome.runtime.connect({ name: 'content' })
    // 结果数据
    const results = []
    // 选中的当前分类index
    let cate1ItemElIndex = 0, cate2ItemElIndex = 0
    // 分类1和分类2,分类1下的项目
    let cate1ElList, cate2ElList, cate1SkuItemElList, cate2SkuItemElList
    // 当前选中的项目
    let currCate1ItemEl, currCate2ItemEl;
    // 选择器
    let selectors = {}
    let selectors1 = {}
    // 默认使用selectors,1为selectors1
    let selectorType = 0

    // 监听后台消息{cmd:collect/collect-next,rdms:延时毫秒,tlcs: tmallListCollectSelectors}
    port.onMessage.addListener((msg) => {
        const msgCmd = msg.cmd;

        console.log('tmall.sku.onMessage', msg)
        // 已经连接 - 延时3秒获取数据
        if (msgCmd === 'connected') {
            setTimeout(() => {
                const body = document.body;
                if (body) {
                    body.style.border = '5px solid #3877cc';
                    const bar = document.createElement("div");
                    bar.style = 'background:#e74747;color:#fff;text-align:center;padding:10px;font-size:24px;font-weight:bold;';
                    bar.innerHTML = "正在采集数据";
                    body.prepend(bar);

                    // 进入准备状态 - 如果没有数据那么则等待3秒后重试3次
                    selectors = msg.selectors
                    selectors1 = msg.selectors1
                    postReadyMessage(5)
                    // port.postMessage({ cmd: 'ready' });
                }
            }, defaultTimeout)
            return
        }

        // TODO 采集本页数据
        if (msgCmd === 'collect') {
            selectors = msg.selectors
            selectors1 = msg.selectors1
            console.log('selectors', selectors, selectors1)
            // 不同逻辑(第2种多)
            // 1.https://item.tmall.com/item.htm?id=756275629874
            // 颜色document.querySelector('.J_Prop.J_Prop_Color')
            // 尺码document.querySelector('.J_Prop.J_Prop_measurement')
            // 尺码列表document.querySelectorAll('.J_Prop.J_Prop_measurement .J_TSaleProp >li')
            // 2.https://item.tmall.com/item.htm?id=747534695596
            // 查询分类document.querySelectorAll('.skuCate .skuCateText')根据文本来判断包含'颜色'的为颜色
            // 另外一个为尺码
            // 内容值document.querySelectorAll('.skuCate .skuItem')
            // document.querySelectorAll('.skuCate .skuItem.current')[0].textContent.trim()
            // document.querySelectorAll('.skuCate .skuItem')[1].click()循环点击获取颜色尺码对应的信息
            // 主图document.querySelector('.PicGallery--mainPicWrap--1c9k21r .PicGallery--mainPic--1eAqOie').src
            // 如果主图不存在则可能是视频，querySelectorAll(.PicGallery--thumbnails--1cEhJzK > li)选择第二个点击后再获取图片
            // 销售数document.querySelector('.ItemHeader--salesDesc--srlk2Hv')
            // 价格document.querySelectorAll('.Price--priceText--2nLbVda')
            // 到手价格document.querySelectorAll('.Price--extraPriceText--2dbLkGw')

            if (selectors || selectors1) {
                handleCollect(5)
            }
            return
        }
    })

    // 发送准备就绪消息,3秒重试次数
    function postReadyMessage(trytimes) {
        console.log('postReadyMessage',)
        const elSelectors = selectorType === 1 ? selectors1 : selectors;

        if (!elSelectors) {
            port.postMessage({ cmd: 'ready' })
            return
        }
        const currCateList = document.querySelectorAll(selectors.skuItemCurrentList)
        if (currCateList.length) {
            port.postMessage({ cmd: 'ready' })
        } else if (trytimes > 0) {
            // 最后2次使用备用selector1
            if (trytimes < 2) {
                selectorType = 0
            }
            setTimeout(() => postReadyMessage(trytimes - 1), 1000)
        } else {
            port.postMessage({ cmd: 'error', value: '没有数据或者采集规则不匹配。' + window.location.href, close: true })
        }
    }

    // 处理采集数据，3秒重试次数
    function handleCollect(trytimes) {
        const elSelectors = selectorType === 1 ? selectors1 : selectors;

        // 获取skuCateList获取分类,一般颜色为第一个,尺寸为第二个
        const skuCateElList = document.querySelectorAll(elSelectors.skuCateList)

        console.log('handleCollect', trytimes, skuCateElList)

        if (!skuCateElList.length && trytimes > 0) {
            setTimeout(() => handleCollect(trytimes - 1), defaultTimeout)
            return
        }

        // 最多处理2个分类
        cate1ElList = skuCateElList[0];
        cate2ElList = skuCateElList.length >= 2 ? skuCateElList[1] : null;

        // 当前选择的分类
        cate1SkuItemElList = cate1ElList.querySelectorAll(elSelectors.skuItemList)

        // 选中的当前分类
        const currItemList = document.querySelectorAll(elSelectors.skuItemCurrentList)
        if (currItemList.length) {
            currCate1ItemEl = currItemList[0]
            currCate2ItemEl = currItemList.length >= 2 ? currItemList[1] : null;
        }
        for (let i = 0; i < cate1SkuItemElList.length; i++) {
            if (cate1SkuItemElList[i] === currCate1ItemEl) {
                cate1ItemElIndex = i
            }
        }

        // 第二个分类
        if (cate2ElList) {
            cate2SkuItemElList = cate2ElList.querySelectorAll(elSelectors.skuItemList)
            for (let i = 0; i < cate2SkuItemElList.length; i++) {
                if (cate2SkuItemElList[i] === currCate2ItemEl) {
                    cate2ItemElIndex = i
                }
            }
        }

        // 采集数据
        pushItemData()
    }

    // 获取采集数据 - 使用selector1
    function getItemData() {
        return selectorType === 1 ? getItemData1() : getItemData0()
    }

    // 获取采集数据 - 使用selector
    function getItemData0() {
        const row = { platform: 'tmall' }

        const chatElDs = document.querySelector(selectors.chat).dataset
        // 商品item(商品id)
        row.item_id = chatElDs.item
        // 客服昵称 - 旺旺
        row.nick = chatElDs.nick

        // 店铺Url: https://shop71438610.tmall.com/
        const shopUrlEl = document.querySelector(selectors.shop_url)
        if (shopUrlEl) {
            const rl = shopUrlEl.href.match(new RegExp('^https://shop(.+).tmall.com*'))
            if (rl && rl.length > 1) {
                row.shop_id = rl[1]
            }
            row.shop_url = shopUrlEl.href
        }
        // 店铺名称
        const shopNameEl = document.querySelector(selectors.shop_name)
        if (shopNameEl) {
            const h = shopNameEl.innerHTML;
            const i = h.indexOf('<span');
            row.shop_name = i >= 0 ? h.substring(0, i) : shopNameEl.textContent.trim();
        }

        // 标题
        const titleEl = document.querySelector(selectors.title)
        if (titleEl) {
            row.title = titleEl.textContent.trim()
        }

        // 商品链接
        row.auction_url = window.location.href

        // 省市(需要去掉至)
        const procityEl = document.querySelector(selectors.procity)
        if (procityEl) {
            const h = procityEl.innerHTML
            const i = h.indexOf('<span');
            row.procity = i >= 0 ? h.substring(0, i) : procityEl.textContent.trim();
        }

        // 销量
        const realSalesEl = document.querySelector(selectors.realSales)
        if (realSalesEl) {
            row.real_sales = realSalesEl.textContent.trim()
        }

        // 价格
        const cpriceEl = document.querySelector(selectors.cPrice)
        if (cpriceEl) {
            row.price = cpriceEl.textContent.trim()
        }

        // 到手价格
        const priceWithRateEl = document.querySelector(selectors.price_with_rate)
        if (priceWithRateEl) {
            row.price_with_rate = priceWithRateEl.textContent.trim()
        }

        // 商品主图
        let mainPicEl = document.querySelector(selectors.mainPic)
        if (mainPicEl) {
            row.pic_path = mainPicEl.src
        }

        // skuId从location中获取
        //https://item.tmall.com/item.htm?abbucket=17&id=760472210876&ns=1&skuId=5413855367664
        const locationHref = window.location.href
        if (!row.item_id) {
            row.item_id = getUrlParam(locationHref, 'id')
        }
        row.sku_id = getUrlParam(locationHref, 'skuId')

        // 颜色尺码规格
        const currCateList = document.querySelectorAll(selectors.skuItemCurrentList)
        if (currCateList.length) {
            row.sku_cate1 = currCateList[0].textContent.trim()
        }
        if (currCateList.length >= 2) {
            row.sku_cate2 = currCateList[1].textContent.trim()
        }
        console.log('row', row)
        return row
    }

    // 获取采集数据 - 使用selector1
    function getItemData1() {
        const row = {}

        //https://item.tmall.com/item.htm?id=595502951197
        const locationHref = window.location.href
        if (!row.item_id) {
            row.item_id = getUrlParam(locationHref, 'id')
        }

        const chatNickEl = document.querySelector(selectors1.chatNick)
        if (chatNickEl && chatNickEl.dataset) {
            // 客服昵称 - 旺旺
            row.nick = chatNickEl.dataset.nick
        }

        // 店铺Url: https://shop71438610.tmall.com/
        const shopUrlEl = document.querySelector(selectors1.shopUrl)
        if (shopUrlEl) {
            const rl = shopUrlEl.href.match(new RegExp('^https://shop(.+).tmall.com*'))
            if (rl && rl.length > 1) {
                row.shop_id = rl[1]
            }
            row.shop_url = shopUrlEl.href
        }

        // 店铺名称
        const shopNameEl = document.querySelector(selectors1.shopName)
        if (shopNameEl) {
            row.shop_name = shopNameEl.textContent.trim()
        }

        // 标题
        const titleEl = document.querySelector(selectors1.title)
        if (titleEl && titleEl.dataset) {
            row.title = titleEl.dataset.title
        }

        // 商品链接
        row.auction_url = window.location.href

        // 省市
        const procityEl = document.querySelector(selectors1.procity)
        if (procityEl) {
            row.procity = procityEl.textContent.trim();
        }

        // 销量
        const realSalesEl = document.querySelector(selectors1.realSales)
        if (realSalesEl) {
            row.real_sales = realSalesEl.textContent.trim()
        }

        // 价格
        const cpriceEl = document.querySelector(selectors1.cPrice)
        if (cpriceEl) {
            row.price = cpriceEl.textContent.trim()
        }

        // 到手价格
        const priceWithRateEl = document.querySelector(selectors1.priceWithRate)
        if (priceWithRateEl) {
            row.price_with_rate = priceWithRateEl.textContent.trim()
        }

        // 商品主图
        let mainPicEl = document.querySelector(selectors1.mainPic)
        if (mainPicEl) {
            row.pic_path = mainPicEl.src
        }

        // TODO skuId
        // row.sku_id = 

        // 颜色尺码规格
        const currCateList = document.querySelectorAll(selectors1.skuItemCurrentList)
        if (currCateList.length) {
            row.sku_cate1 = currCateList[0].textContent.trim()
        }
        if (currCateList.length >= 2) {
            row.sku_cate2 = currCateList[1].textContent.trim()
        }
        console.log('row', row)
        return row
    }

    // 获取采集数据,并写入results
    function pushItemData() {
        console.log('getItemData:', cate1ItemElIndex, cate2ItemElIndex, results)

        let finished = cate1ItemElIndex >= cate1SkuItemElList.length - 1;
        if (finished && cate2SkuItemElList) {
            finished = cate2ItemElIndex >= cate2SkuItemElList.length - 1;
        }

        // 上传当前页面数据，每页时单独采集的
        port.postMessage({ cmd: 'result', value: [getItemData()], close: finished });

        if (finished) {
            return;
        }

        if (cate2ElList) {
            // 点击下个cate2项目
            cate2ItemElIndex = cate2ItemElIndex + 1
            if (cate2ItemElIndex >= cate2SkuItemElList.length) {
                // 移动cate1ItemElIndex
                cate1ItemElIndex = cate1ItemElIndex + 1
                if (cate1ItemElIndex >= cate1SkuItemElList.length) {
                    return
                }
                // 点击下一个cate1
                cate1SkuItemElList[cate1ItemElIndex].click()
            } else {
                // 点击下一个cate2
                cate2SkuItemElList[cate2ItemElIndex].click()
            }
        } else {
            // 移动cate1ItemElIndex
            cate1ItemElIndex = cate1ItemElIndex + 1
            if (cate1ItemElIndex >= cate1SkuItemElList.length) {
                return
            }
            // 点击下一个cate1
            cate1SkuItemElList[cate1ItemElIndex].click()
        }
    }

    function getUrlParam(url, paramName) {
        const searchParams = new URLSearchParams(new URL(url).search);
        return searchParams.get(paramName);
    }
})()