// 淘宝店铺所有宝贝查询页面
// https://*.tmall.com/search.htm?
// https://yeehoocc.tmall.com/search.htm?orderType=&viewType=grid&keyword=&lowPrice=&highPrice=
(function () {
    console.log('tmall.shop.search@1.2.1')
    const defaultTimeout = 3000
    // 连接后台
    const port = chrome.runtime.connect({ name: 'content' })

    // 监听后台消息{cmd:collect/collect-next,rdms:延时毫秒,tlcs: tmallListCollectSelectors}
    port.onMessage.addListener((msg) => {
        const msgCmd = msg.cmd;

        console.log('tmall.shop.onMessage', msg)
        // 已经连接 - 延时3秒获取数据
        if (msgCmd === 'connected') {
            setTimeout(() => {
                const body = document.body;
                if (body) {
                    body.style.border = '5px solid #3877cc';
                    const bar = document.createElement("div");
                    bar.style = 'background: #e74747;color:#fff;text-align:center;padding:10px;font-size:24px;font-weight:bold;';
                    bar.innerHTML = "正在采集数据";
                    body.prepend(bar);

                    // 进入准备状态 - 如果没有数据那么则等待3秒后重试3次
                    postReadyMessage(msg.selectors, 5)
                    // port.postMessage({ cmd: 'ready' });
                }
            }, defaultTimeout)
            return
        }

        // 采集本页数据
        if (msgCmd === 'collect') {
            console.log('collect', msg)
            const selectors = msg.selectors
            if (selectors) {

                console.log('pageInfoEl', selectors.pageInfo)
                // 更新最大页码. 页码信息 当前页/总页数
                const pageInfoEl = document.querySelector(selectors.pageInfo)
                if (pageInfoEl) {
                    console.log('pageInfoEl.innerText', pageInfoEl.innerText)
                    const l = pageInfoEl.innerText.split('/')
                    if (l.length === 2) {
                        port.postMessage({ cmd: 'maxpage', value: l[1] });
                    }
                }

                const results = []
                // list,mainPic,title,price1,price2,shop,shopLogo,realSales,shopww,city,page,chat
                const list = getDataList(selectors);
                // let list = document.querySelectorAll(selectors.list)
                // // 默认是item3line1，如果不存在则尝试item4line1，item5line1，item2line1
                // if (!list.length) list = document.querySelectorAll(selectors.list4)
                // if (!list.length) list = document.querySelectorAll(selectors.list30)
                console.log('list', list)
                if (list.length) handleCollect(results, selectors, list, 0)
            }
            return
        }

        // 翻到下一页
        if (msgCmd === 'pagedown') {
            const pagedownBtn = document.querySelector(msg.pagedownBtnSelector)
            if (pagedownBtn) {
                pagedownBtn.click()
                // 3秒后进入准备状态
                setTimeout(() => postReadyMessage(msg.selectors, 5), defaultTimeout)
                // setTimeout(() => port.postMessage({ cmd: 'ready' }), defaultTimeout)
            } else {
                // 执行完毕
                port.postMessage({ cmd: 'finished' })
                return;
            }
            return
        }
    })

    function getDataList(selectors) {
        let list = document.querySelectorAll(selectors.list)
        // 默认是item3line1，如果不存在则尝试item4line1，item5line1，item2line1
        if (!list.length) list = document.querySelectorAll(selectors.list4)
        if (!list.length) list = document.querySelectorAll(selectors.list30)
        if (!list.length) list = document.querySelectorAll(selectors.list5)
        if (!list.length) list = document.querySelectorAll(selectors.list6)
        console.log('list', list)
        return list
    }

    // 发送准备就绪消息,3秒重试次数
    function postReadyMessage(selectors, trytimes) {
        console.log('ready.message', selectors, trytimes)
        if (!selectors) {
            port.postMessage({ cmd: 'ready' })
            return
        }
        // const list = document.querySelectorAll(selectors.list)
        const list = getDataList(selectors);
        console.log('ready.message.list', list)
        if (list.length) {
            port.postMessage({ cmd: 'ready' })
        } else if (trytimes > 0) {
            setTimeout(() => postReadyMessage(selectors, trytimes - 1), defaultTimeout)
        } else {
            port.postMessage({ cmd: 'error', value: '没有数据或者采集规则不匹配。' + window.location.href, close: true })
        }
    }

    // 处理采集数据，淘宝数据如果需要显示图片才会赋值
    function handleCollect(results, selectors, itemElList, elIndex) {
        const el = itemElList[elIndex]
        // const rect = el.getBoundingClientRect()
        // const newScrollY = rect.top + rect.height
        // const timeout = window.scrollY != newScrollY ? 200 : 0;
        // window.scrollTo(0, newScrollY)
        const timeout = window.scrollY != el.offsetTop ? 300 : 100;
        // window.scrollTo(0, 0)
        window.scrollTo({
            top: el.offsetTop,
            behavior: 'smooth'
        })
        setTimeout(async () => {
            results.push(await pushItemData(selectors, el))
            elIndex = elIndex + 1
            if (elIndex >= itemElList.length) {
                port.postMessage({ cmd: 'result', value: results });
                return
            }
            handleCollect(results, selectors, itemElList, elIndex)
        }, timeout)
    }

    // 获取采集数据
    async function pushItemData(selectors, el) {
        console.log('selectors', selectors)
        const row = {}

        // 商品item(商品id)
        const elDs = el.dataset
        row.item_id = elDs.id
        
        // 店铺ID
        // pageId=1719695953;prototypeId=3;siteCategory=2;siteInstanceId=532588365;shopId=103167781;userId=57694717
        const metaMdContent = document.querySelector('meta[name=microscope-data]').content
        const mdcm = metaMdContent.match(new RegExp('shopId=([0-9]+)'))
        if (mdcm.length > 1) {
            row.shop_id = mdcm[1]
        }

        // 店铺
        const shopNameEl = document.querySelector(selectors.shopName)
        if (shopNameEl) {
            row.shop_title = shopNameEl.innerText
            row.shop_url = shopNameEl.href
        }
        const shopNickEl = document.querySelector(selectors.shopNick)
        if (shopNickEl && shopNickEl.dataset) {
            row.nick = decodeURIComponent(shopNickEl.dataset.nick)
        }

        // 标题,商品链接
        const titleEl = el.querySelector(selectors.title)
        if (titleEl) {
            row.title = titleEl.innerText
            row.auction_url = titleEl.href
        }

        // 价格 - 转换数据
        const cpriceEl = el.querySelector(selectors.cPrice)
        if (cpriceEl) {
            row.price = await as102cftext(cpriceEl.innerText)
            console.log('row.price', row.price)
        }
        const spriceEl = el.querySelector(selectors.sPrice)
        if (spriceEl) {
            row.sprice = await as102cftext(spriceEl.innerText)
            console.log('row.sprice', row.sprice)
        }

        // 实际销量
        const realSalesEl = el.querySelector(selectors.realSales)
        if (realSalesEl) row.real_sales = realSalesEl.innerText

        // 页码
        const pageEl = document.querySelector(selectors.page)
        if (pageEl) row.page = pageEl.innerText

        // 商品主图，如果主图不存在那么向下滚动itemOffsetHeight
        let mainPicEl = el.querySelector(selectors.mainPic)
        if (mainPicEl) {
            row.pic_path = mainPicEl.src
        }

        // 聊天url
        const chatEl = document.querySelector(selectors.chat)
        if (chatEl) {
            row.chat_url = chatEl.href
        }
        console.log('row', row)
        return row
    }

    async function as102cftext(value) {
        if (!value) return Promise.resolve('')
        return new Promise((resolve) => {
            chrome.runtime.sendMessage({ 'cmd': 'as102cftext', value }, (res) => {
                console.log('as102cftext', value, res)
                return resolve(res)
            })
        })
    }
})()